<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CTestimonials extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		$this->name = "testimonials";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		if ($_GET["mod"] == $this->name) {
			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];
		
			switch ($sub) {

				case "texts":
					return $this->__adminTexts();
				break;


				case "landing":
					$sub = "items";
				case "items":
				case "cats":
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;

			}
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:testimonials_items" , 
			"plugin:testimonials_items_lang",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {

		$this->CreatePageTitleBlock(array(
			"module_id"	=> $module_data["mod_id"],
			"title"		=> $module_data["mod_name"],
			"subtitle"	=> "You can edit this section in the Module Head tab",
			"show"		=> 1,
		));

		$this->plugins["modules"]->CreateLangRecord(
			$this->tables["plugin:testimonials_cats"],
			$this->tables["plugin:testimonials_cats_lang"],
			"cat_id",
			"cat_order",
			array(
				"module_id"		=> $module_data["mod_id"],
				"cat_title"		=> "Default Category",
				"cat_url"		=> "default-category",
				"cat_status"	=> "1",

				"cat_size"		=> 4,
				"cat_size_lg"	=> 4,
				"cat_size_md"	=> 4,
				"cat_size_sm"	=> 6,
				"cat_size_xs"	=> 12,
			)
		);


	}

	
}

?>